VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4110
   ClientLeft      =   2220
   ClientTop       =   2025
   ClientWidth     =   5610
   LinkTopic       =   "Form1"
   ScaleHeight     =   4110
   ScaleWidth      =   5610
   Begin VB.CommandButton cmdExit 
      Caption         =   "OK"
      Height          =   495
      Left            =   4320
      TabIndex        =   10
      Top             =   3480
      Width           =   735
   End
   Begin VB.Frame Frame1 
      Caption         =   "Sample Rate (Hz)"
      Height          =   1335
      Left            =   720
      TabIndex        =   6
      Top             =   2040
      Width           =   1815
      Begin VB.OptionButton Option1 
         Caption         =   "10 KHz"
         Height          =   255
         Index           =   2
         Left            =   240
         TabIndex        =   9
         Top             =   960
         Width           =   1095
      End
      Begin VB.OptionButton Option1 
         Caption         =   "10 Hz"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   8
         Top             =   600
         Value           =   -1  'True
         Width           =   1095
      End
      Begin VB.OptionButton Option1 
         Caption         =   "1 Hz"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   7
         Top             =   240
         Width           =   1095
      End
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   2880
      TabIndex        =   4
      Text            =   "0"
      Top             =   720
      Width           =   615
   End
   Begin VB.ListBox List1 
      Height          =   1815
      Left            =   2880
      TabIndex        =   3
      Top             =   1320
      Width           =   1815
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Scan AI channels"
      Enabled         =   0   'False
      Height          =   375
      Left            =   720
      TabIndex        =   1
      Top             =   1320
      Width           =   1695
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   720
      TabIndex        =   0
      Top             =   720
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   4920
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   4920
      Top             =   840
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label2 
      Caption         =   "Device Number: "
      Height          =   255
      Left            =   2880
      TabIndex        =   5
      Top             =   360
      Width           =   1335
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   600
      TabIndex        =   2
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit ' require variable declaration
Dim SampleRate As Single
Dim AIData() As Single
' tested in Win2K SP4 with KPCMCIA-850A04.0.0.2 DriverLINX version
'
' for multi channel analog input, there is a BUG:
' as soon as the task is started, a buffer filled message will
' be sent immediately.  This data in this false buffer filled message
' is junk.  Workaround:  ask for N+1 buffers and ignore the first buffer.
'
' This effect is not seen for single channel tasks.

Private Sub cmdExit_Click()
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End
End Sub

Private Sub cmdInit_Click()
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "kpcaiao"  ' give driver name to avoid Open DriverLINX dialog
.Req_device = devNum.ListIndex
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
' use of the LDD control is not required
If SR.Res_result = DL_NoErr Then
cmdSample.Enabled = True
cmdInit.Enabled = False
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.Refresh
Form1.Caption = "Paced Analog Input with " & LDD.Dev_Model  'from the LDD, determine the model number
Else
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If
' the LDD control can inform your application
' about the features of the hardware
Form1.SetFocus
End Sub

Private Sub cmdSample_Click()
List1.Clear  ' clear the list box
SetupAIPaced
SR.Refresh  ' do it
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
' see Private Sub SR_BufferFilled() for what happens next
End Sub

Private Sub Form_Load()
' load devNum with legal values
Dim i As Integer
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
' set it to first entry
devNum.ListIndex = 0

' set SampleRate equal to the default radio button, 10Hz
SampleRate = 10
End Sub

Private Sub Form_Terminate()
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

Sub SetupAIPaced()
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_INTERRUPT  ' could be DL_DMA if board has DMA feature
.Req_subsystem = DL_AI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_RATEEVENT ' timing will be used
.Evt_Tim_rateChannel = DL_DEFAULTTIMER  ' each board has default timing channel
.Evt_Tim_rateClock = DL_INTERNAL1       ' internal1 timebase
.Evt_Tim_rateGate = DL_NOCONNECT   ' no gating
.Evt_Tim_rateMode = DL_RATEGEN     ' one sample for each tic of clock
.Evt_Tim_rateOutput = CT_Output_Default ' not used for RATEGEN
.Evt_Tim_ratePeriod = .DLSecs2Tics(0, 1 / SampleRate) ' 10Hz default rate
' Select Group
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 2                ' 2 means a start channel and stop channel
.Sel_chan_start = 0            ' start on channel 0
.Sel_chan_startGainCode = .DLGain2Code(-1) ' negative = bipolar, 1 = gain of 1
.Sel_chan_stop = LDD.AI_nChan - 1
.Sel_chan_stopGainCode = .DLGain2Code(-1) 'stop on channel 7
' allocate one buffer equal to number of channels for the data
.Sel_buf_N = 2          ' ask for 2 buffers since we have a BUG
.Sel_buf_samples = LDD.AI_nChan ' LDD tells us how many channels we have
' the buffer MUST be a multiple of how many channels are in the scan, e.g., 8, 16, etc.
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message
End With
End Sub

Private Sub Option1_Click(Index As Integer)
Select Case Index
Case 0: SampleRate = 1
Case 1: SampleRate = 10
Case 2: SampleRate = 10000
End Select
End Sub

Private Sub SR_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
' for multi channel analog input, there is a BUG:
' as soon as the task is started, a buffer filled message will
' be sent immediately.  This data in this false buffer filled message
' is junk.  Workaround:  ask for N+1 buffers and ignore the first buffer.
'
' This effect is not seen for single channel tasks.
If bufIndex <> 0 Then
Beep
' allocate array for the data and some other variables that will be needed
ReDim AIData(LDD.AI_nChan) As Single  ' still hard coding size of the array/buffers
' for the AIAO-C cards it will be 8 if SE, but 4 if differential
' for the AI-C cards it will be 16 if SE, but 8 if differential
Dim dummy As Single
Dim i As Integer
List1.Clear  ' clear the list box

' the BufferFilled message contains the bufIndex that is ready for conversion
dummy = SR.VBArrayBufferConvert(bufIndex, 0, LDD.AI_nChan, AIData, DL_tSINGLE, 0, 0)
For i = 0 To LDD.AI_nChan - 1
List1.AddItem "chan #: " & Str(i) & "  " & Str(Format(AIData(i), "##.##0"))
Next i
End If
End Sub
